/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;

public class RecipeGen_Fluids
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_Fluids(Material M) {
        this(M, false);
    }

    public RecipeGen_Fluids(Material M, boolean dO) {
        this.toGenerate = M;
        this.disableOptional = dO;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    private void generateRecipes(Material material, boolean dO) {
        if (material == null) {
            return;
        }
        if (material.getFluidStack(1) != null && !material.getFluidStack(1).getUnlocalizedName().toLowerCase().contains("plasma")) {
            if (ItemUtils.checkForInvalidItems(material.getIngot(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Ingot.get(0L, new Object[0]), material.getFluidStack(144), material.getIngot(1), 32, material.vVoltageMultiplier)) {
                    Logger.WARNING("144l fluid molder for 1 ingot Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("144l fluid molder for 1 ingot Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getPlate(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Plate.get(0L, new Object[0]), material.getFluidStack(144), material.getPlate(1), 32, material.vVoltageMultiplier)) {
                    Logger.WARNING("144l fluid molder for 1 plate Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("144l fluid molder for 1 plate Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getNugget(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Nugget.get(0L, new Object[0]), material.getFluidStack(16), material.getNugget(1), 16, material.vVoltageMultiplier)) {
                    Logger.WARNING("16l fluid molder for 1 nugget Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("16l fluid molder for 1 nugget Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getGear(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Gear.get(0L, new Object[0]), material.getFluidStack(576), material.getGear(1), 128, material.vVoltageMultiplier)) {
                    Logger.WARNING("576l fluid molder for 1 gear Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("576l fluid molder for 1 gear Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getBlock(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Block.get(0L, new Object[0]), material.getFluidStack(1296), material.getBlock(1), 288, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 block Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 block Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getRod(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rod.get(0L, new Object[0]), material.getFluidStack(72), material.getRod(1), 150, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 rod Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 rod Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getLongRod(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0]), material.getFluidStack(144), material.getLongRod(1), 300, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 rod long Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 rod long Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getBolt(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Bolt.get(0L, new Object[0]), material.getFluidStack(18), material.getBolt(1), 50, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 bolt Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 bolt Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getScrew(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Screw.get(0L, new Object[0]), material.getFluidStack(18), material.getScrew(1), 50, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 screw Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 screw Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getRing(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Ring.get(0L, new Object[0]), material.getFluidStack(36), material.getRing(1), 100, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 ring Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 ring Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
            if (ItemUtils.checkForInvalidItems(material.getRotor(1))) {
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rotor.get(0L, new Object[0]), material.getFluidStack(612), material.getRotor(1), 100, material.vVoltageMultiplier)) {
                    Logger.WARNING("1296l fluid molder from 1 rotor Recipe: " + material.getLocalizedName() + " - Success");
                } else {
                    Logger.WARNING("1296l fluid molder from 1 rotor Recipe: " + material.getLocalizedName() + " - Failed");
                }
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

