/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.registration.gregtech;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic.GregtechMetaTileEntity_BasicWasher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechSimpleWasher {
    public static void run() {
        if (CORE.ConfigSwitches.enableMachine_SimpleWasher) {
            GregtechSimpleWasher.generateDirtyDustRecipes();
            GregtechSimpleWasher.generateDirtyCrushedRecipes();
            GregtechItemList.SimpleDustWasher_ULV.set(new GregtechMetaTileEntity_BasicWasher(767, "simplewasher.01.tier.01", "Simple Washer I", 0).getStackForm(1L));
            GregtechItemList.SimpleDustWasher_MV.set(new GregtechMetaTileEntity_BasicWasher(31017, "simplewasher.01.tier.02", "Simple Washer II", 2).getStackForm(1L));
            GregtechItemList.SimpleDustWasher_EV.set(new GregtechMetaTileEntity_BasicWasher(31018, "simplewasher.01.tier.03", "Simple Washer III", 4).getStackForm(1L));
            GregtechItemList.SimpleDustWasher_LuV.set(new GregtechMetaTileEntity_BasicWasher(31019, "simplewasher.01.tier.04", "Simple Washer IV", 6).getStackForm(1L));
            GregtechItemList.SimpleDustWasher_UV.set(new GregtechMetaTileEntity_BasicWasher(31020, "simplewasher.01.tier.05", "Simple Washer V", 8).getStackForm(1L));
        }
    }

    private static boolean generateDirtyDustRecipes() {
        ItemStack dustDirty;
        ItemStack dustClean;
        int mRecipeCount = 0;
        for (Materials v : Materials.values()) {
            if (v == Materials.Platinum || v == Materials.Osmium || v == Materials.Iridium || v == Materials.Palladium) continue;
            dustClean = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)v, (long)1L);
            dustDirty = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustImpure, (Object)v, (long)1L);
            GregtechSimpleWasher.addSimpleWashRecipe(dustDirty, dustClean);
        }
        for (Werkstoff v : Werkstoff.werkstoffHashSet) {
            dustClean = v.hasItemType(OrePrefixes.dust) ? v.get(OrePrefixes.dust) : null;
            dustDirty = v.hasItemType(OrePrefixes.dustImpure) ? v.get(OrePrefixes.dustImpure) : null;
            GregtechSimpleWasher.addSimpleWashRecipe(dustDirty, dustClean);
        }
        return GTPP_Recipe.GTPP_Recipe_Map.sSimpleWasherRecipes.mRecipeList.size() > mRecipeCount;
    }

    private static boolean generateDirtyCrushedRecipes() {
        ItemStack crushedDirty;
        ItemStack crushedClean;
        int mRecipeCount = GTPP_Recipe.GTPP_Recipe_Map.sSimpleWasherRecipes.mRecipeList.size();
        for (Materials v : Materials.values()) {
            crushedClean = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)v, (long)1L);
            crushedDirty = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushed, (Object)v, (long)1L);
            GregtechSimpleWasher.addSimpleWashRecipe(crushedDirty, crushedClean);
        }
        for (Werkstoff v : Werkstoff.werkstoffHashSet) {
            crushedClean = v.hasItemType(OrePrefixes.crushedPurified) ? v.get(OrePrefixes.crushedPurified) : null;
            crushedDirty = v.hasItemType(OrePrefixes.crushed) ? v.get(OrePrefixes.crushed) : null;
            GregtechSimpleWasher.addSimpleWashRecipe(crushedDirty, crushedClean);
        }
        return GTPP_Recipe.GTPP_Recipe_Map.sSimpleWasherRecipes.mRecipeList.size() > mRecipeCount;
    }

    private static void addSimpleWashRecipe(ItemStack aInput, ItemStack aOutput) {
        if (aInput != null && aOutput != null) {
            GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[0], new FluidStack[]{FluidUtils.getFluidStack("water", 100)}, new FluidStack[0], 5, 8, 0);
            GTPP_Recipe.GTPP_Recipe_Map.sSimpleWasherRecipes.addRecipe(aRecipe);
        }
    }
}

