/*
 * Decompiled with CFR 0.152.
 */
package jss.bugtorch.mixins.early.minecraft.logcleanup;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={NioSocketChannel.class}, remap=false)
public abstract class MixinNioSocketChannel
extends AbstractNioByteChannel {
    MixinNioSocketChannel(Channel parent, SelectableChannel ch) {
        super(parent, ch);
    }

    @Overwrite
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        block11: {
            int i;
            long writtenBytes;
            block10: {
                do {
                    int msgCount;
                    if ((msgCount = in.size()) <= 1) {
                        super.doWrite(in);
                        return;
                    }
                    ByteBuffer[] nioBuffers = in.nioBuffers();
                    if (nioBuffers == null) {
                        super.doWrite(in);
                        return;
                    }
                    int nioBufferCnt = in.nioBufferCount();
                    long expectedWrittenBytes = in.nioBufferSize();
                    SocketChannel ch = (SocketChannel)this.javaChannel();
                    writtenBytes = 0L;
                    boolean done = false;
                    for (i = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
                        long localWrittenBytes = 0L;
                        try {
                            localWrittenBytes = ch.write(nioBuffers, 0, nioBufferCnt);
                        }
                        catch (IOException ex) {
                            this.close();
                        }
                        if (localWrittenBytes == 0L) break;
                        writtenBytes += localWrittenBytes;
                        if ((expectedWrittenBytes -= localWrittenBytes) != 0L) continue;
                        done = true;
                        break;
                    }
                    if (!done) break block10;
                    for (i = msgCount; i > 0; --i) {
                        in.remove();
                    }
                } while (!in.isEmpty());
                this.clearOpWrite();
                break block11;
            }
            for (i = msgCount; i > 0; --i) {
                ByteBuf buf = (ByteBuf)in.current();
                int readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if ((long)readableBytes < writtenBytes) {
                    in.progress((long)readableBytes);
                    in.remove();
                    writtenBytes -= (long)readableBytes;
                    continue;
                }
                if ((long)readableBytes > writtenBytes) {
                    buf.readerIndex(readerIndex + (int)writtenBytes);
                    in.progress(writtenBytes);
                    break;
                }
                in.progress((long)readableBytes);
                in.remove();
                break;
            }
            this.setOpWrite();
        }
    }
}

