/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseOrientation;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.IProperty;
import gcewing.architecture.PropertyInteger;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShapeBlock
extends BaseBlock<ShapeTE> {
    protected AxisAlignedBB boxHit;
    public static IProperty<Integer> LIGHT = PropertyInteger.create("light", 0, 15);

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(LIGHT);
    }

    @Override
    public int getNumSubtypes() {
        return 16;
    }

    public ShapeBlock() {
        super(Material.field_151576_e, ShapeTE.class);
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient24WaysByTE;
    }

    @Override
    public boolean isFullCube() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, BlockPos pos, Vec3 start, Vec3 end) {
        MovingObjectPosition result = null;
        double nearestDistance = 0.0;
        IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, pos);
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, null);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB box = list.get(i);
                MovingObjectPosition mp = box.func_72327_a(start, end);
                if (mp == null) continue;
                mp.subHit = i;
                double d = start.func_72436_e(mp.field_72307_f);
                if (result != null && !(d < nearestDistance)) continue;
                result = mp;
                nearestDistance = d;
            }
        }
        if (result != null) {
            int i = result.subHit;
            this.boxHit = list.get(i).func_72317_d((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
            result = BaseUtils.newMovingObjectPosition(result.field_72307_f, result.field_72310_e, pos);
            result.subHit = i;
        }
        return result;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, BlockPos pos) {
        ShapeTE te;
        if (this.boxHit != null && (te = ShapeTE.get(world, pos)) != null && te.shape.kind.highlightZones()) {
            this.setBlockBounds(this.boxHit);
            return;
        }
        IBlockState state = BaseBlockUtils.getWorldBlockState(world, pos);
        AxisAlignedBB box = this.getLocalBounds(world, pos, state, null);
        if (box != null) {
            this.setBlockBounds(box);
        } else {
            super.setBlockBoundsBasedOnState(world, pos);
        }
    }

    @Override
    public void setBlockBounds(AxisAlignedBB box) {
        this.func_149676_a((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
    }

    @Override
    public void addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB clip, List result, Entity entity) {
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, entity);
        if (list != null) {
            for (AxisAlignedBB box : list) {
                if (!clip.func_72326_a(box)) continue;
                result.add(box);
            }
        }
    }

    @Override
    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        ShapeTE te = (ShapeTE)BaseBlockUtils.getWorldTileEntity(world, pos);
        if (te != null) {
            Trans3 t = te.localToGlobalTransformation();
            return this.getCollisionBoxes(te, world, pos, state, t, entity);
        }
        return null;
    }

    @Override
    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        ShapeTE te = (ShapeTE)BaseBlockUtils.getWorldTileEntity(world, pos);
        if (te != null) {
            Trans3 t = te.localToGlobalTransformation(Vector3.zero);
            return this.getCollisionBoxes(te, world, pos, state, t, entity);
        }
        return null;
    }

    @Override
    protected AxisAlignedBB getLocalBounds(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        ShapeTE te = (ShapeTE)BaseBlockUtils.getWorldTileEntity(world, pos);
        if (te != null) {
            Trans3 t = te.localToGlobalTransformation(Vector3.blockCenter);
            return te.shape.kind.getBounds(te, world, pos, state, entity, t);
        }
        return null;
    }

    protected List<AxisAlignedBB> getCollisionBoxes(ShapeTE te, IBlockAccess world, BlockPos pos, IBlockState state, Trans3 t, Entity entity) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        te.shape.kind.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
        return list;
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    protected ArrayList<ItemStack> getDropsFromTileEntity(IBlockAccess world, BlockPos pos, IBlockState state, TileEntity te, int fortune) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (te instanceof ShapeTE) {
            ShapeTE ste = (ShapeTE)te;
            ItemStack stack = ste.shape.kind.newStack(ste.shape, ste.baseBlockState, 1);
            result.add(stack);
            if (ste.secondaryBlockState != null) {
                stack = ste.shape.kind.newSecondaryMaterialStack(ste.secondaryBlockState);
                result.add(stack);
            }
        }
        return result;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        ShapeTE te = ShapeTE.get((IBlockAccess)world, pos);
        if (te != null) {
            return te.newItemStack(1);
        }
        return null;
    }

    public IBlockState getBaseBlockState(IBlockAccess world, BlockPos pos) {
        ShapeTE te = (ShapeTE)this.getTileEntity(world, pos);
        if (te != null) {
            return te.baseBlockState;
        }
        return null;
    }

    @Override
    public float getPlayerRelativeBlockHardness(EntityPlayer player, World world, BlockPos pos) {
        float result = 1.0f;
        IBlockState base = this.getBaseBlockState((IBlockAccess)world, pos);
        if (base != null) {
            result = ShapeBlock.acBlockStrength(base, player, world, pos);
        }
        return result;
    }

    public static float acBlockStrength(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        float hardness = BaseBlockUtils.getBlockHardness(state.getBlock(), world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        float strength = BaseBlockUtils.getPlayerBreakSpeed(player, state, pos) / hardness;
        if (!ShapeBlock.acCanHarvestBlock(state, player)) {
            return strength / 100.0f;
        }
        return strength / 30.0f;
    }

    public static boolean acCanHarvestBlock(IBlockState state, EntityPlayer player) {
        Block block = state.getBlock();
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        String tool = BaseBlockUtils.getBlockHarvestTool(state);
        if (stack == null || tool == null) {
            return player.func_146099_a(block);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool);
        if (toolLevel < 0) {
            return player.func_146099_a(block);
        }
        return toolLevel >= BaseBlockUtils.getBlockHarvestLevel(state);
    }

    @Override
    public IBlockState getParticleState(IBlockAccess world, BlockPos pos) {
        IBlockState base = this.getBaseBlockState(world, pos);
        if (base != null) {
            return base;
        }
        return this.getDefaultState();
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ShapeTE te;
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && (te = ShapeTE.get((IBlockAccess)world, pos)) != null) {
            return te.applySecondaryMaterial(stack, player);
        }
        return false;
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_149685_I() {
        return 0.8f;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int result = world.func_72805_g(x, y, z);
        return result;
    }
}

