/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockPaint;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.items.ToolColorApplicatorRender;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.DispenserBlockTool;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.storage.CellInventoryHandler;
import appeng.tile.misc.TilePaint;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class ToolColorApplicator
extends AEBasePoweredItem
implements IStorageCell,
IItemGroup,
IBlockTool,
IMouseWheelItem {
    private static final Map<Integer, AEColor> ORE_TO_COLOR = new HashMap<Integer, AEColor>();

    public ToolColorApplicator() {
        super(AEConfig.instance.colorApplicatorBattery, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.ColorApplicator, AEFeature.PoweredTools));
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ToolColorApplicatorRender());
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBlockTool());
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block blk = w.func_147439_a(x, y, z);
        ItemStack paintBall = this.getColor(is);
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (inv != null) {
            IAEItemStack option = inv.extractItems(AEItemStack.create(paintBall), Actionable.SIMULATE, new BaseActionSource());
            if (option != null) {
                paintBall = option.getItemStack();
                paintBall.field_77994_a = 1;
            } else {
                paintBall = null;
            }
            if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
                return false;
            }
            double powerPerUse = 100.0;
            if (paintBall != null && paintBall.func_77973_b() instanceof ItemSnowball) {
                ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
                TileEntity te = w.func_147438_o(x, y, z);
                if (te instanceof IColorableTile && this.getAECurrentPower(is) > 100.0 && ((IColorableTile)te).getColor() != AEColor.Transparent && ((IColorableTile)te).recolourBlock(orientation, AEColor.Transparent, p)) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0);
                    return true;
                }
                Block testBlk = w.func_147439_a(x + orientation.offsetX, y + orientation.offsetY, z + orientation.offsetZ);
                TileEntity painted = w.func_147438_o(x + orientation.offsetX, y + orientation.offsetY, z + orientation.offsetZ);
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof BlockPaint && painted instanceof TilePaint) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0);
                    ((TilePaint)painted).cleanSide(orientation.getOpposite());
                    return true;
                }
            } else if (paintBall != null) {
                AEColor color = this.getColorFromItem(paintBall);
                TileEntity te = w.func_147438_o(x, y, z);
                if (te instanceof IColorableTile) {
                    IColorableTile colorable = (IColorableTile)te;
                    colorable.recolourBlock(ForgeDirection.getOrientation((int)side), color, p);
                    return true;
                }
                if (color != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.Transparent && this.recolourBlock(blk, ForgeDirection.getOrientation((int)side), w, x, y, z, ForgeDirection.getOrientation((int)side), color, p)) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0);
                    return true;
                }
            }
        }
        if (p.func_70093_af()) {
            this.cycleColors(is, paintBall, 1);
        }
        return false;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String extra = GuiText.Empty.getLocal();
        AEColor selected = this.getActiveColor(par1ItemStack);
        if (selected != null && Platform.isClient()) {
            extra = Platform.gui_localize(selected.unlocalizedName);
        }
        return super.func_77653_i(par1ItemStack) + " - " + extra;
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    private AEColor getColorFromItem(ItemStack paintBall) {
        int[] id;
        if (paintBall == null) {
            return null;
        }
        if (paintBall.func_77973_b() instanceof ItemSnowball) {
            return AEColor.Transparent;
        }
        Item item = paintBall.func_77973_b();
        if (item instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)item;
            return ipb.getColor(paintBall);
        }
        for (int oreID : id = OreDictionary.getOreIDs((ItemStack)paintBall)) {
            if (!ORE_TO_COLOR.containsKey(oreID)) continue;
            return ORE_TO_COLOR.get(oreID);
        }
        return null;
    }

    public ItemStack getColor(ItemStack is) {
        NBTTagCompound color;
        ItemStack oldColor;
        NBTTagCompound c = is.func_77978_p();
        if (c != null && c.func_74764_b("color") && (oldColor = ItemStack.func_77949_a((NBTTagCompound)(color = c.func_74775_l("color")))) != null) {
            return oldColor;
        }
        return this.findNextColor(is, null, 0);
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = null;
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (inv != null) {
            IItemList<IAEItemStack> itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList());
            if (anchor == null) {
                IAEItemStack firstItem = itemList.getFirstItem();
                if (firstItem != null) {
                    newColor = firstItem.getItemStack();
                }
            } else {
                LinkedList<IAEItemStack> list = new LinkedList<IAEItemStack>();
                for (IAEItemStack i : itemList) {
                    list.add(i);
                }
                list.sort((a, b) -> ItemSorters.compareInt(a.getItemDamage(), b.getItemDamage()));
                if (list.size() <= 0) {
                    return null;
                }
                IAEItemStack where = (IAEItemStack)list.getFirst();
                for (int cycles = 1 + list.size(); cycles > 0 && !where.equals(anchor); --cycles) {
                    list.addLast((IAEItemStack)list.removeFirst());
                    where = (IAEItemStack)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((IAEItemStack)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((IAEItemStack)list.removeLast());
                }
                return ((IAEItemStack)list.get(0)).getItemStack();
            }
        }
        if (newColor != null) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(ItemStack is, ItemStack newColor) {
        NBTTagCompound data = Platform.openNbtData(is);
        if (newColor == null) {
            data.func_82580_o("color");
        } else {
            NBTTagCompound color = new NBTTagCompound();
            newColor.func_77955_b(color);
            data.func_74782_a("color", (NBTBase)color);
        }
    }

    private boolean recolourBlock(Block blk, ForgeDirection side, World w, int x, int y, int z, ForgeDirection orientation, AEColor newColor, EntityPlayer p) {
        if (blk == Blocks.field_150404_cg) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, Blocks.field_150404_cg, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150359_w) {
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150399_cn, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150399_cn) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150399_cn, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150410_aZ) {
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150397_co, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150397_co) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150397_co, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150405_ch) {
            return w.func_147465_d(x, y, z, Blocks.field_150406_ce, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150406_ce) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, Blocks.field_150406_ce, newColor.ordinal(), 3);
        }
        if (blk instanceof BlockCableBus) {
            return ((BlockCableBus)blk).recolourBlock(w, x, y, z, side, newColor.ordinal(), p);
        }
        return blk.recolourBlock(w, x, y, z, side, newColor.ordinal());
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall == null) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventory cd;
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (cdi instanceof CellInventoryHandler && (cd = ((ICellInventoryHandler)cdi).getCellInv()) != null) {
            lines.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int BytePerType(ItemStack cell) {
        return 8;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        if (requestedAddition != null) {
            int[] id;
            for (int x : id = OreDictionary.getOreIDs((ItemStack)requestedAddition.getItemStack())) {
                if (!ORE_TO_COLOR.containsKey(x)) continue;
                return false;
            }
            if (requestedAddition.getItem() instanceof ItemSnowball) {
                return false;
            }
            return !(requestedAddition.getItem() instanceof ItemPaintBall) || requestedAddition.getItemDamage() >= 20;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    @Override
    public String getOreFilter(ItemStack is) {
        return Platform.openNbtData(is).func_74779_i("OreFilter");
    }

    @Override
    public void setOreFilter(ItemStack is, String filter) {
        Platform.openNbtData(is).func_74778_a("OreFilter", filter);
    }

    static {
        for (AEColor col : AEColor.values()) {
            if (col == AEColor.Transparent) continue;
            ORE_TO_COLOR.put(OreDictionary.getOreID((String)("dye" + col.name())), col);
        }
    }
}

