/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.circuits.ISocketable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketSocketUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private ItemStack[] itemStacks;

    public PacketSocketUpdate() {
    }

    public <T extends TileEntity> PacketSocketUpdate(T tile) {
        super(tile);
        this.itemStacks = new ItemStack[((ISocketable)tile).getSocketCount()];
        for (int i = 0; i < ((ISocketable)tile).getSocketCount(); ++i) {
            this.itemStacks[i] = ((ISocketable)tile).getSocket(i);
        }
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeItemStacks(this.itemStacks);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.itemStacks = data.readItemStacks();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (!(tile instanceof ISocketable)) {
            return;
        }
        ISocketable socketable = (ISocketable)tile;
        for (int i = 0; i < this.itemStacks.length; ++i) {
            socketable.setSocket(i, this.itemStacks[i]);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.SOCKET_UPDATE;
    }
}

